<!-- business information here -->
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <!-- <link rel="stylesheet" href="style.css"> -->
        <title>Receipt-<?php echo e($receipt_details->invoice_no, false); ?></title>
    </head>
    <body>
        <div class="ticket border-bottom-dotted" style="margin-top: 1px !important">
        	
        	
        	<?php if(!empty($receipt_details->logo)): ?>
        		<div class="text-box centered">
        			<img style="max-height: 100px; width: auto;" src="<?php echo e($receipt_details->logo, false); ?>" alt="Logo">
        		</div>
        	<?php endif; ?>
        	<div class="text-box">
        	<!-- Logo -->
            <p class="centered">
            	<!-- Header text -->
            	<?php if(!empty($receipt_details->header_text)): ?>
            		<span class="headings"style="font-size: 16px;font-weight: bold;"><?php echo $receipt_details->header_text; ?></span>
					<br/>
				<?php endif; ?>

				<!-- business information here -->
					<br/>
				<?php if(!empty($receipt_details->display_name)): ?>
					<span class="headings" style="font-size: 16px;font-weight: bold;">
						<?php echo e($receipt_details->display_name, false); ?>

					</span>
					<br/>
				<?php endif; ?>
				
				<?php if(!empty($receipt_details->address)): ?>
					<span class="headings" style="font-size: 10px;font-weight: bold;"><?php echo $receipt_details->address; ?>

						</span>
					<br/>
				<?php endif; ?>

				<?php if(!empty($receipt_details->contact)): ?>
				<span class="headings" style="font-size: 10px;font-weight: bold;">
					<?php echo $receipt_details->contact; ?>

					</span>
				<?php endif; ?>
				<?php if(!empty($receipt_details->contact) && !empty($receipt_details->website)): ?>
					, 
				<?php endif; ?>
				<?php if(!empty($receipt_details->website)): ?>
					<?php echo e($receipt_details->website, false); ?>

				<?php endif; ?>
				<?php if(!empty($receipt_details->location_custom_fields)): ?>
					<br><?php echo e($receipt_details->location_custom_fields, false); ?>

				<?php endif; ?>

				<?php if(!empty($receipt_details->sub_heading_line1)): ?>
					<?php echo e($receipt_details->sub_heading_line1, false); ?><br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line2)): ?>
					<?php echo e($receipt_details->sub_heading_line2, false); ?><br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line3)): ?>
					<?php echo e($receipt_details->sub_heading_line3, false); ?><br/>
				<?php endif; ?>
				<?php if(!empty($receipt_details->sub_heading_line4)): ?>
					<?php echo e($receipt_details->sub_heading_line4, false); ?><br/>
				<?php endif; ?>		
				<?php if(!empty($receipt_details->sub_heading_line5)): ?>
					<?php echo e($receipt_details->sub_heading_line5, false); ?><br/>
				<?php endif; ?>

				<?php if(!empty($receipt_details->tax_info1)): ?>
					<br><b><?php echo e($receipt_details->tax_label1, false); ?></b> <?php echo e($receipt_details->tax_info1, false); ?>

				<?php endif; ?>

				<?php if(!empty($receipt_details->tax_info2)): ?>
					<b><?php echo e($receipt_details->tax_label2, false); ?></b> <?php echo e($receipt_details->tax_info2, false); ?>

				<?php endif; ?>

				<!-- Title of receipt -->
				<?php if(!empty($receipt_details->invoice_heading)): ?>
					<br/><span class="sub-headings"><?php echo $receipt_details->invoice_heading; ?></span>
				<?php endif; ?>
			</p>
			</div>
			<div class="border-top textbox-info" style="margin-left: 2px ">
				<p class="f-left"><strong><?php echo $receipt_details->invoice_no_prefix; ?></strong></p>
				<p class="f-right">
					<?php echo e($receipt_details->invoice_no, false); ?>

				</p>
			</div>
			<div class="textbox-info">
				<p class="f-left"><strong><?php echo $receipt_details->date_label; ?></strong></p>
				<p class="f-right">
					<?php echo e($receipt_details->invoice_date, false); ?>

				</p>
			</div>
			
			<?php if(!empty($receipt_details->due_date_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->due_date_label, false); ?></strong></p>
					<p class="f-right"><?php echo e($receipt_details->due_date ?? '', false); ?></p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->sales_person_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->sales_person_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->sales_person, false); ?></p>
				</div>
			<?php endif; ?>
			<?php if(!empty($receipt_details->commission_agent_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->commission_agent_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->commission_agent, false); ?></p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->brand_label) || !empty($receipt_details->repair_brand)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->brand_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->repair_brand, false); ?></p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->device_label) || !empty($receipt_details->repair_device)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->device_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->repair_device, false); ?></p>
				</div>
			<?php endif; ?>
			
			<?php if(!empty($receipt_details->model_no_label) || !empty($receipt_details->repair_model_no)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->model_no_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->repair_model_no, false); ?></p>
				</div>
			<?php endif; ?>
			
			<?php if(!empty($receipt_details->serial_no_label) || !empty($receipt_details->repair_serial_no)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong><?php echo e($receipt_details->serial_no_label, false); ?></strong></p>
				
					<p class="f-right"><?php echo e($receipt_details->repair_serial_no, false); ?></p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->repair_status_label) || !empty($receipt_details->repair_status)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo $receipt_details->repair_status_label; ?>

					</strong></p>
					<p class="f-right">
						<?php echo e($receipt_details->repair_status, false); ?>

					</p>
				</div>
        	<?php endif; ?>

        	<?php if(!empty($receipt_details->repair_warranty_label) || !empty($receipt_details->repair_warranty)): ?>
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			<?php echo $receipt_details->repair_warranty_label; ?>

	        		</strong></p>
	        		<p class="f-right">
	        			<?php echo e($receipt_details->repair_warranty, false); ?>

	        		</p>
	        	</div>
        	<?php endif; ?>

        	<!-- Waiter info -->
			<?php if(!empty($receipt_details->service_staff_label) || !empty($receipt_details->service_staff)): ?>
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			<?php echo $receipt_details->service_staff_label; ?>

	        		</strong></p>
	        		<p class="f-right">
	        			<?php echo e($receipt_details->service_staff, false); ?>

					</p>
	        	</div>
	        <?php endif; ?>

	        <?php if(!empty($receipt_details->table_label) || !empty($receipt_details->table)): ?>
	        	<div class="textbox-info">
	        		<p class="f-left"><strong>
	        			<?php if(!empty($receipt_details->table_label)): ?>
							<b><?php echo $receipt_details->table_label; ?></b>
						<?php endif; ?>
	        		</strong></p>
	        		<p class="f-right">
	        			<?php echo e($receipt_details->table, false); ?>

	        		</p>
	        	</div>
	        <?php endif; ?>

	        <!-- customer info -->
	        <div class="textbox-info">
	        	<p style="vertical-align: top;"><strong>
	        		<?php echo e($receipt_details->customer_label ?? '', false); ?>

	        	</strong></p>

	        	<p>
	        		<?php if(!empty($receipt_details->customer_info)): ?>
	        			<div class="bw">
						<?php echo $receipt_details->customer_info; ?>

						</div>
					<?php endif; ?>
	        	</p>
	        </div>
			
			<?php if(!empty($receipt_details->client_id_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo e($receipt_details->client_id_label, false); ?>

					</strong></p>
					<p class="f-right">
						<?php echo e($receipt_details->client_id, false); ?>

					</p>
				</div>
			<?php endif; ?>
			
			<?php if(!empty($receipt_details->customer_tax_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo e($receipt_details->customer_tax_label, false); ?>

					</strong></p>
					<p class="f-right">
						<?php echo e($receipt_details->customer_tax_number, false); ?>

					</p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->customer_custom_fields)): ?>
				<div class="textbox-info">
					<p class="centered">
						<?php echo $receipt_details->customer_custom_fields; ?>

					</p>
				</div>
			<?php endif; ?>
			
			<?php if(!empty($receipt_details->customer_rp_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo e($receipt_details->customer_rp_label, false); ?>

					</strong></p>
					<p class="f-right">
						<?php echo e($receipt_details->customer_total_rp, false); ?>

					</p>
				</div>
			<?php endif; ?>
			<?php if(!empty($receipt_details->shipping_custom_field_1_label)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo $receipt_details->shipping_custom_field_1_label; ?> 
					</strong></p>
					<p class="f-right">
						<?php echo $receipt_details->shipping_custom_field_1_value ?? ''; ?>

					</p>
				</div>
			<?php endif; ?>
			
		
			<?php if(!empty($receipt_details->sale_orders_invoice_no)): ?>
				<div class="textbox-info">
					<p class="f-left"><strong>
						<?php echo app('translator')->getFromJson('restaurant.order_no'); ?>
					</strong></p>
					<p class="f-right">
						<?php echo $receipt_details->sale_orders_invoice_no ?? ''; ?>

					</p>
				</div>
			<?php endif; ?>

			<?php if(!empty($receipt_details->sale_orders_invoice_date)): ?>
				<div class="textbox-info" style="margin-left: 2px ">
					<p class="f-left"><strong>
						<?php echo app('translator')->getFromJson('lang_v1.order_dates'); ?>
					</strong></p>
					<p class="f-right">
						<?php echo $receipt_details->sale_orders_invoice_date ?? ''; ?>

					</p>
				</div>
			<?php endif; ?>

            <table style="margin-top: 1px;margin-left: 1px !important;" class="border-bottom width-100 table-f-12 mb-10">
                <thead class="border-bottom-dotted" style="margin-top: 1px !important">
                    <tr>
                        
                        <th class="description" width="30%" style="font-size: 9px;font-weight: bold;">
                        	<?php echo e($receipt_details->table_product_label, false); ?>

                        </th>
                        <th class="MRP text-right"style="font-size: 9px;font-weight: bold;" >Mrp</th>
                        <th class="quantity text-right" style="font-size: 9px;">
                        	<?php echo e($receipt_details->table_qty_label, false); ?>

                        </th>
                        <?php if(empty($receipt_details->hide_price)): ?>
                        <th class="unit_price text-right" style="font-size: 9px;">
                        	<?php echo e($receipt_details->table_unit_price_label, false); ?>

                        </th>
<?php endif; ?>
                        <?php if(!empty($receipt_details->item_discount_label)): ?>
							<th class="text-right" width="10%" style="font-size: 9px;"><?php echo e($receipt_details->item_discount_label, false); ?></th>
						<?php endif; ?>

                        <?php if(!empty($receipt_details->table_subtotal_label)): ?>
                        <th class="price text-right" style="font-size: 9px;"><?php echo e($receipt_details->table_subtotal_label, false); ?></th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                	
                	 <?php $product_saving = [];  ?>
                	<?php $__empty_1 = true; $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                	 <?php
                        $mrp = $line['unit_price_before_discount_uf'];
                        if(isset($line['product_custom_fields'])) {
                            if($line['product_custom_fields']) {
                                $c_arr = explode(',', $line['product_custom_fields']);
                                $mtemp = isset($c_arr[0])? $c_arr[0]:0;
                                if($mtemp) {
                                    $mrp = $mtemp;
                                }
                                if(isset($c_arr[1])) {
                                    unset($c_arr[0]);
                                    $line['product_custom_fields'] = implode(', ', $c_arr);
                                } else {
                                    $line['product_custom_fields'] = '';
                                }
                            }
                        }
                        
                        $mrp_total = $mrp*$line['quantity_uf'];
                        //echo $mrp_total; exit;
                        if($mrp_total>($line['unit_price_before_discount_uf']*$line['quantity_uf'])) {
                            $product_saving[] = $mrp_total - ($line['unit_price_before_discount_uf']*$line['quantity_uf']);
                        } else {
                            $product_saving[] = 0;
                        }
                        
                    ?>
                	 
	                    <tr>
	                        <!-- <td class="serial_number" style="vertical-align: top;">
	                        	<?php echo e($loop->iteration, false); ?>

	                        </td> -->
	                        <td class="description" style="font-size: 7px;font-weight: bold;">
	                        	<?php echo e($line['name'], false); ?> 
	                        	
	                        
	                        	
	                           
	                        </td>
	                        <td class="text-right" style="font-size: 7px;font-weight: bold;"><?php echo e($mrp, false); ?></td>
	                        <td class="quantity text-right" style="font-size: 7px;"><?php echo e($line['quantity'], false); ?></td>
	                        <?php if(empty($receipt_details->hide_price)): ?>
	                        <td class="unit_price text-right" style="font-size: 7px;font-weight: bold;"><?php echo e($line['unit_price_before_discount'], false); ?></td>
	                         <?php endif; ?>
	                        <td class="price text-right" style="font-size: 7px;font-weight: bold;"><?php echo e($line['line_total'], false); ?></td>
	                        
	                    </tr>
	                  
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                   

                </tbody>
            </table>
				<?php if(!empty($receipt_details->total_quantity_label)): ?>
				<div class="flex-box">
				<p class="width-40 text-right sub-headings">
						<?php echo $receipt_details->total_quantity_label; ?>

					</p>
					<p class="width-40 text-right sub-headings">
						<?php echo e($receipt_details->total_quantity, false); ?>

					</p>
				</div>
			<?php endif; ?>
			<?php if(empty($receipt_details->hide_price)): ?>
                <div class="flex-box">
                    <p class="left text-right sub-headings">
                    	<?php echo $receipt_details->subtotal_label; ?>

                    </p>
                    <p class="width-40 text-right sub-headings">
                    	<?php echo e($receipt_details->subtotal, false); ?>

                    </p>
                </div>

                <!-- Shipping Charges -->
				<?php if(!empty($receipt_details->shipping_charges)): ?>
					<div class="flex-box">
						<p class="left text-right">
							<?php echo $receipt_details->shipping_charges_label; ?>

						</p>
						<p class="width-40 text-right">
							<?php echo e($receipt_details->shipping_charges, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<?php if(!empty($receipt_details->packing_charge)): ?>
					<div class="flex-box">
						<p class="left text-right">
							<?php echo $receipt_details->packing_charge_label; ?>

						</p>
						<p class="width-40 text-right">
							<?php echo e($receipt_details->packing_charge, false); ?>

						</p>
					</div>
				<?php endif; ?>

			


				<?php if(!empty($receipt_details->reward_point_label) ): ?>
					<div class="flex-box">
						<p class="width-40 text-right">
							<?php echo $receipt_details->reward_point_label; ?>

						</p>

						<p class="width-40 text-right">
							(-) <?php echo e($receipt_details->reward_point_amount, false); ?>

						</p>
					</div>
				<?php endif; ?>

			

				<?php if( $receipt_details->round_off_amount > 0): ?>
					<div class="flex-box">
						<p class="width-40 text-right">
							<?php echo $receipt_details->round_off_label; ?> 
						</p>
						<p class="width-40 text-right">
							<?php echo e($receipt_details->round_off, false); ?>

						</p>
					</div>
				<?php endif; ?>

				<div class="flex-box">
					<p class="width-40 text-right sub-headings">
						<?php echo $receipt_details->total_label; ?>

					</p>
					<p class="width-40 text-right sub-headings">
						<?php echo e($receipt_details->total, false); ?>

					</p>
				</div>
				
			<!-- 	<?php if(!empty($receipt_details->payments)): ?>
					<?php $__currentLoopData = $receipt_details->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="flex-box">
							<p class="width-40 text-right"><?php echo e($payment['method'], false); ?> (<?php echo e($payment['date'], false); ?>) </p>
							<p class="width-40 text-right"><?php echo e($payment['amount'], false); ?></p>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?> -->

				<!-- Total Paid-->
				

				<!-- Total Due-->
				<?php if(!empty($receipt_details->total_due)): ?>
					<div class="flex-box">
						<p class="width-40 text-right sub-headings">
							<?php echo $receipt_details->total_due_label; ?>

						</p>
						<p class="width-40 text-right sub-headings">
							<?php echo e($receipt_details->total_due, false); ?>

						</p>
					</div>
				<?php endif; ?>
			<!-- 	<?php if(!empty($receipt_details->total_in_words)): ?>
				<p colspan="2" class="text-right mb-0">
					<small>
					(<?php echo e($receipt_details->total_in_words, false); ?>)
					</small>
				</p>
				<?php endif; ?> -->
<?php 
        $saving = 0.00;
        if($product_saving) {
            $saving = array_sum($product_saving);
        }
        if($saving>0.001) {
            $total_saving = $saving;
        } else {
            $total_saving = '0.00';
        }
        
    ?>
   	<div class="flex-box">
     <p class="width-40 text-right sub-headings">Total Savings</p> : <p class="width-40 text-right sub-headings">₹ <?php echo e($total_saving, false); ?></p>
    </div>
				<?php if(!empty($receipt_details->all_due)): ?>
					<div class="flex-box">
						<p class="width-40 text-right">
							<?php echo $receipt_details->all_bal_label; ?>

						</p>
						<p class="width-40 text-right">
							<?php echo e($receipt_details->all_due, false); ?>

						</p>
					</div>
				<?php endif; ?>
			<?php endif; ?>
            <div class="border-bottom width-100">&nbsp;</div>
            

 
            <?php if(!empty($receipt_details->additional_notes)): ?>
	            <p class="centered" >
	            	<?php echo nl2br($receipt_details->additional_notes); ?>

	            </p>
            <?php endif; ?>

            
			<?php if($receipt_details->show_barcode): ?>
				<br/>
				<img class="center-block" src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG($receipt_details->invoice_no, 'C128', 2,30,array(39, 48, 54), true), false); ?>">
			<?php endif; ?>

			<?php if($receipt_details->show_qr_code && !empty($receipt_details->qr_code_details)): ?>
				<?php
					$qr_code_text = implode(', ', $receipt_details->qr_code_details);
				?>
				<img class="center-block mt-5" src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($qr_code_text, 'QRCODE'), false); ?>">
			<?php endif; ?>
			
			<?php if(!empty($receipt_details->footer_text)): ?>
				<p class="centered">
					<?php echo $receipt_details->footer_text; ?>

				</p>
			<?php endif; ?>
			
        </div>
        <!-- <button id="btnPrint" class="hidden-print">Print</button>
        <script src="script.js"></script> -->
    </body>
</html>
<style type="text/css">
.f-8 {
	font-size: 8px !important;
}
@media  print {
	* {
    	font-size: 8px;
    	font-family:verdana, arial, sans-serif;
    	word-wrap: break-word;
    	
	}
	.f-8 {
		
	}
	
.headings{
	font-size: 10px;
	font-size:bold;
}

.sub-headings{
	font-size: 15px !important;
	font-weight: 500 !important;
}

.border-top{
    border-top: 1px solid #242424;
}
.border-bottom{
	border-bottom: 1px solid #242424;
}

.border-bottom-dotted{
	border-bottom: 1px dotted black;
}
.text-box {
	width: 100%;
	height: auto;
}

.textbox-info {
	clear: both;
	font-family:verdana, arial, sans-serif;
}
.textbox-info p {
	margin-bottom: -1px;
	margin-left: 2px ;
	font-family:verdana, arial, sans-serif;
}
.flex-box {
	display: flex;
	width: 100%;
	font-family:verdana, arial, sans-serif;
	/*border-bottom: 1px dotted black;*/
}
.flex-box p {
	width: 50%;
	margin-bottom: 0px;
	white-space: nowrap;
	font-family:verdana, arial, sans-serif;
}

.table-f-12 th, .table-f-12 td {
	font-size: 12px;
	word-wrap: break-word;
	/*border-bottom: 1px dotted black;*/
}

.bw {
	word-wrap: break-word;
}
.centered {
    text-align: center;
    align-content: center;
    	font-family:verdana, arial, sans-serif;
}

.ticket {
    width: 100%;
    max-width: 100%;
    border-bottom: 1px dotted black;
}

img {
    max-width: inherit;
    width: auto;
}
</style><?php /**PATH /home1/webapps2/trial.neowep.com/resources/views/sale_pos/receipts/slim.blade.php ENDPATH**/ ?>